/**
 * \file sdc_ctl_args.h
 *
 * \brief SDC_CTL : Define types, enums, structs related to arg parsing
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __SDC_CTL_ARGS_
#define __SDC_CTL_ARGS_

#include "sdc_ctl_action.h"
#include "sdc_ctl.h"

/**
 * Parsed cli arguments.  Used by main to communicate with parse_opt.
 */
typedef struct sdc_ctl_arguments {
    action_t *first_action;
    action_t *last_action;

    /* generic flags */
    logging_t log_level;
} arguments_t;

sdc_error_t sdc_ctl_parse_args (int argc, char **argv, arguments_t *arguments);

#endif
